/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DE represents the number of elapsed (TAI) milliseconds since the ITS Epoch. 
 * The ITS epoch is `00:00:00.000 UTC, 1 January 2004`.
 * "Elapsed" means that the true number of milliseconds is continuously counted without interruption,
 *  i.e. it is not altered by leap seconds, which occur in UTC.
 * 
 * @note: International Atomic Time (TAI) is the time reference coordinate on the basis of the readings of atomic clocks, 
 * operated in accordance with the definition of the second, the unit of time of the International System of Units. 
 * TAI is a continuous time scale. UTC has discontinuities, as it is occasionally adjusted by leap seconds. 
 * As of 1 January, 2022, TimestampIts is 5 seconds ahead of UTC, because since the ITS epoch on 1 January 2004 00:00:00.000 UTC, 
 * further 5 leap seconds have been inserted in UTC.
 * 
 * EXAMPLE: The value for TimestampIts for 1 January 2007 00:00:00.000 UTC is `94 694 401 000` milliseconds,
 * which includes one leap second insertion since the ITS epoch.
 * @unit: 0,001 s
 * @category: Basic information
 * @revision: Description revised in in V2.1.1
 *
TimestampIts ::= INTEGER (0..4398046511103)
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_TimestampIts.h>
#include <etsi_its_denm_ts_coding/INTEGER.h>
#include <etsi_its_primitives_conversion/convertINTEGER.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/TimestampIts.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/timestamp_its.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_TimestampIts(const denm_ts_TimestampIts_t& in, denm_ts_msgs::TimestampIts& out) {
  etsi_its_primitives_conversion::toRos_INTEGER(in, out.value);
}

void toStruct_TimestampIts(const denm_ts_msgs::TimestampIts& in, denm_ts_TimestampIts_t& out) {
  memset(&out, 0, sizeof(denm_ts_TimestampIts_t));
  etsi_its_primitives_conversion::toStruct_INTEGER(in.value, out);
}

}
