/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF represents a velocity vector with associated confidence value.
 *
 * The following options are available:
 * 
 * @field polarVelocity: the representation of the velocity vector in a polar or cylindrical coordinate system. 
 * 
 * @field cartesianVelocity: the representation of the velocity vector in a cartesian coordinate system.
 * 
 * @category: Kinematic information
 * @revision: Created in V2.1.1
 *
Velocity3dWithConfidence::= CHOICE{
    polarVelocity          VelocityPolarWithZ, 
    cartesianVelocity      VelocityCartesian
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_Velocity3dWithConfidence.h>
#include <etsi_its_denm_ts_conversion/convertVelocityCartesian.h>
#include <etsi_its_denm_ts_conversion/convertVelocityPolarWithZ.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/Velocity3dWithConfidence.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/velocity3d_with_confidence.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_Velocity3dWithConfidence(const denm_ts_Velocity3dWithConfidence_t& in, denm_ts_msgs::Velocity3dWithConfidence& out) {
  switch (in.present) {
  case denm_ts_Velocity3dWithConfidence_PR_polarVelocity:
    toRos_VelocityPolarWithZ(in.choice.polarVelocity, out.polar_velocity);
    out.choice = denm_ts_msgs::Velocity3dWithConfidence::CHOICE_POLAR_VELOCITY;
    break;
  case denm_ts_Velocity3dWithConfidence_PR_cartesianVelocity:
    toRos_VelocityCartesian(in.choice.cartesianVelocity, out.cartesian_velocity);
    out.choice = denm_ts_msgs::Velocity3dWithConfidence::CHOICE_CARTESIAN_VELOCITY;
    break;
  default: break;
  }
}

void toStruct_Velocity3dWithConfidence(const denm_ts_msgs::Velocity3dWithConfidence& in, denm_ts_Velocity3dWithConfidence_t& out) {
  memset(&out, 0, sizeof(denm_ts_Velocity3dWithConfidence_t));
  switch (in.choice) {
  case denm_ts_msgs::Velocity3dWithConfidence::CHOICE_POLAR_VELOCITY:
    toStruct_VelocityPolarWithZ(in.polar_velocity, out.choice.polarVelocity);
    out.present = denm_ts_Velocity3dWithConfidence_PR::denm_ts_Velocity3dWithConfidence_PR_polarVelocity;
    break;
  case denm_ts_msgs::Velocity3dWithConfidence::CHOICE_CARTESIAN_VELOCITY:
    toStruct_VelocityCartesian(in.cartesian_velocity, out.choice.cartesianVelocity);
    out.present = denm_ts_Velocity3dWithConfidence_PR::denm_ts_Velocity3dWithConfidence_PR_cartesianVelocity;
    break;
  default: break;
  }
}

}
