/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF represents a velocity vector in a cartesian coordinate system.
 
 * It shall include the following components: 
 * 
 * @field xVelocity: the x component of the velocity vector with the associated confidence value.
 * 
 * @field yVelocity: the y component of the velocity vector with the associated confidence value.
 *
 * @field zVelocity: the optional z component of the velocity vector with the associated confidence value.
 * 
 * @category: Kinematic information
 * @revision: Created in V2.1.1
 *
VelocityCartesian::= SEQUENCE {
    xVelocity   VelocityComponent,
    yVelocity   VelocityComponent,
    zVelocity   VelocityComponent OPTIONAL
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_VelocityCartesian.h>
#include <etsi_its_denm_ts_conversion/convertVelocityComponent.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/VelocityCartesian.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/velocity_cartesian.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_VelocityCartesian(const denm_ts_VelocityCartesian_t& in, denm_ts_msgs::VelocityCartesian& out) {
  toRos_VelocityComponent(in.xVelocity, out.x_velocity);
  toRos_VelocityComponent(in.yVelocity, out.y_velocity);
  if (in.zVelocity) {
    toRos_VelocityComponent(*in.zVelocity, out.z_velocity);
    out.z_velocity_is_present = true;
  }
}

void toStruct_VelocityCartesian(const denm_ts_msgs::VelocityCartesian& in, denm_ts_VelocityCartesian_t& out) {
  memset(&out, 0, sizeof(denm_ts_VelocityCartesian_t));
  toStruct_VelocityComponent(in.x_velocity, out.xVelocity);
  toStruct_VelocityComponent(in.y_velocity, out.yVelocity);
  if (in.z_velocity_is_present) {
    out.zVelocity = (denm_ts_VelocityComponent_t*) calloc(1, sizeof(denm_ts_VelocityComponent_t));
    toStruct_VelocityComponent(in.z_velocity, *out.zVelocity);
  }
}

}
