/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DF indicates the profile of a VRU including sub-profile information
 * It identifies four options corresponding to the four types of VRU profiles specified in ETSI TS 103 300-2 [18]:
 *
 * @field pedestrian: VRU Profile 1 - Pedestrian.
 *
 * @field bicyclistAndLightVruVehicle: VRU Profile  2 - Bicyclist.
 *
 * @field motorcyclist: VRU Profile 3  - Motorcyclist.
 *
 * @field animal: VRU Profile  4 -  Animal.
 *
 * @category: VRU information
 * @revision: Created in V2.1.1
 *
VruProfileAndSubprofile ::= CHOICE {
   pedestrian                     VruSubProfilePedestrian,
   bicyclistAndLightVruVehicle    VruSubProfileBicyclist,
   motorcyclist                   VruSubProfileMotorcyclist,
   animal                         VruSubProfileAnimal,
   ...
}
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_VruProfileAndSubprofile.h>
#include <etsi_its_denm_ts_conversion/convertVruSubProfileAnimal.h>
#include <etsi_its_denm_ts_conversion/convertVruSubProfileBicyclist.h>
#include <etsi_its_denm_ts_conversion/convertVruSubProfileMotorcyclist.h>
#include <etsi_its_denm_ts_conversion/convertVruSubProfilePedestrian.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/VruProfileAndSubprofile.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/vru_profile_and_subprofile.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_VruProfileAndSubprofile(const denm_ts_VruProfileAndSubprofile_t& in, denm_ts_msgs::VruProfileAndSubprofile& out) {
  switch (in.present) {
  case denm_ts_VruProfileAndSubprofile_PR_pedestrian:
    toRos_VruSubProfilePedestrian(in.choice.pedestrian, out.pedestrian);
    out.choice = denm_ts_msgs::VruProfileAndSubprofile::CHOICE_PEDESTRIAN;
    break;
  case denm_ts_VruProfileAndSubprofile_PR_bicyclistAndLightVruVehicle:
    toRos_VruSubProfileBicyclist(in.choice.bicyclistAndLightVruVehicle, out.bicyclist_and_light_vru_vehicle);
    out.choice = denm_ts_msgs::VruProfileAndSubprofile::CHOICE_BICYCLIST_AND_LIGHT_VRU_VEHICLE;
    break;
  case denm_ts_VruProfileAndSubprofile_PR_motorcyclist:
    toRos_VruSubProfileMotorcyclist(in.choice.motorcyclist, out.motorcyclist);
    out.choice = denm_ts_msgs::VruProfileAndSubprofile::CHOICE_MOTORCYCLIST;
    break;
  case denm_ts_VruProfileAndSubprofile_PR_animal:
    toRos_VruSubProfileAnimal(in.choice.animal, out.animal);
    out.choice = denm_ts_msgs::VruProfileAndSubprofile::CHOICE_ANIMAL;
    break;
  default: break;
  }
}

void toStruct_VruProfileAndSubprofile(const denm_ts_msgs::VruProfileAndSubprofile& in, denm_ts_VruProfileAndSubprofile_t& out) {
  memset(&out, 0, sizeof(denm_ts_VruProfileAndSubprofile_t));
  switch (in.choice) {
  case denm_ts_msgs::VruProfileAndSubprofile::CHOICE_PEDESTRIAN:
    toStruct_VruSubProfilePedestrian(in.pedestrian, out.choice.pedestrian);
    out.present = denm_ts_VruProfileAndSubprofile_PR::denm_ts_VruProfileAndSubprofile_PR_pedestrian;
    break;
  case denm_ts_msgs::VruProfileAndSubprofile::CHOICE_BICYCLIST_AND_LIGHT_VRU_VEHICLE:
    toStruct_VruSubProfileBicyclist(in.bicyclist_and_light_vru_vehicle, out.choice.bicyclistAndLightVruVehicle);
    out.present = denm_ts_VruProfileAndSubprofile_PR::denm_ts_VruProfileAndSubprofile_PR_bicyclistAndLightVruVehicle;
    break;
  case denm_ts_msgs::VruProfileAndSubprofile::CHOICE_MOTORCYCLIST:
    toStruct_VruSubProfileMotorcyclist(in.motorcyclist, out.choice.motorcyclist);
    out.present = denm_ts_VruProfileAndSubprofile_PR::denm_ts_VruProfileAndSubprofile_PR_motorcyclist;
    break;
  case denm_ts_msgs::VruProfileAndSubprofile::CHOICE_ANIMAL:
    toStruct_VruSubProfileAnimal(in.animal, out.choice.animal);
    out.present = denm_ts_VruProfileAndSubprofile_PR::denm_ts_VruProfileAndSubprofile_PR_animal;
    break;
  default: break;
  }
}

}
