/** ============================================================================
MIT License

Copyright (c) 2023-2025 Institute for Automotive Engineering (ika), RWTH Aachen University

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
============================================================================= */

/** Auto-generated by https://github.com/ika-rwth-aachen/etsi_its_messages -----
python3 \
  utils/codegen/codegen-py/asn1ToConversionHeader.py \
  asn1/raw/denm_ts103831/DENM-PDU-Descriptions.asn \
  asn1/patched/denm_ts103831/cdd/ETSI-ITS-CDD.asn \
  -t \
  denm_ts \
  -o \
  etsi_its_conversion/etsi_its_denm_ts_conversion/include/etsi_its_denm_ts_conversion
----------------------------------------------------------------------------- */

/** ASN.1 Definition -----------------------------------------------------------
*
 * This DE indicates the profile of a VRU and its light VRU vehicle / mounted animal. 
 *
 * The value shall be set to:
 * - 0 `unavailable`           - to indicate that the information  is unavailable,
 * - 1 `bicyclist `            - to indicate a cycle and bicyclist to which no more-specific profile applies, 
 * - 2 `wheelchair-user`       - to indicate a wheelchair and its user,
 * - 3 `horse-and-rider`       - to indicate a horse and rider,
 * - 4 `rollerskater`          - to indicate a roller-skater and skater,
 * - 5 `e-scooter`             - to indicate an e-scooter and rider,
 * - 6 `personal-transporter`  - to indicate a personal-transporter and rider,
 * - 7 `pedelec`               - to indicate a pedelec and rider to which no more-specific profile applies,
 * - 8 `speed-pedelec`         - to indicate a speed-pedelec and rider.
 * - 9 `roadbike`              - to indicate a road bicycle (or road pedelec) and rider,
 * - 10 `childrensbike`        - to indicate a children�s bicycle (or children�s pedelec) and rider,
 * - 11 to 15                  - are reserved for future usage. 
 *
 * @category: VRU information
 * @revision: Created in V2.1.1, values 9 and 10 assigned in V2.2.1
 *
VruSubProfileBicyclist ::= INTEGER {
    unavailable          (0), 
    bicyclist            (1), 
    wheelchair-user      (2), 
    horse-and-rider      (3), 
    rollerskater         (4), 
    e-scooter            (5), 
    personal-transporter (6),
    pedelec              (7), 
    speed-pedelec        (8),
    roadbike             (9),
    childrensbike        (10)
}(0..15)
----------------------------------------------------------------------------- */

#pragma once

#include <etsi_its_denm_ts_coding/denm_ts_VruSubProfileBicyclist.h>
#include <etsi_its_denm_ts_coding/INTEGER.h>
#include <etsi_its_primitives_conversion/convertINTEGER.h>
#ifdef ROS1
#include <etsi_its_denm_ts_msgs/VruSubProfileBicyclist.h>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs;
#else
#include <etsi_its_denm_ts_msgs/msg/vru_sub_profile_bicyclist.hpp>
namespace denm_ts_msgs = etsi_its_denm_ts_msgs::msg;
#endif


namespace etsi_its_denm_ts_conversion {

void toRos_VruSubProfileBicyclist(const denm_ts_VruSubProfileBicyclist_t& in, denm_ts_msgs::VruSubProfileBicyclist& out) {
  etsi_its_primitives_conversion::toRos_INTEGER(in, out.value);
}

void toStruct_VruSubProfileBicyclist(const denm_ts_msgs::VruSubProfileBicyclist& in, denm_ts_VruSubProfileBicyclist_t& out) {
  memset(&out, 0, sizeof(denm_ts_VruSubProfileBicyclist_t));
  etsi_its_primitives_conversion::toStruct_INTEGER(in.value, out);
}

}
